/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.TrafficType;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class SimulationEvent
extends IPCEvent {
    public EventType type;

    public SimulationEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        FORWARD_STARTED,
        FORWARD_ENDED,
        NEW_FRAME_INSTANCE_ADDED,
        SIMULATION_RESET,
        SIMULATION_MODE_CHANGED;

    }

    public static class SimulationModeChanged
    extends SimulationEvent {
        public SimulationModeChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.SIMULATION_MODE_CHANGED;
        }

        public String toString() {
            return super.toString();
        }
    }

    public static class SimulationReset
    extends SimulationEvent {
        public SimulationReset(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.SIMULATION_RESET;
        }

        public String toString() {
            return super.toString();
        }
    }

    public static class NewFrameInstanceAdded
    extends SimulationEvent {
        public TrafficType trafficType;
        public Integer index;

        public NewFrameInstanceAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.NEW_FRAME_INSTANCE_ADDED;
            this.trafficType = TrafficType.fromIntValue((Integer)ltv.getEventParameters().get(0));
            this.index = (Integer)ltv.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\ttrafficType = " + (Object)((Object)this.trafficType) + "\n\tindex = " + this.index;
        }
    }

    public static class ForwardEnded
    extends SimulationEvent {
        public ForwardEnded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FORWARD_ENDED;
        }

        public String toString() {
            return super.toString();
        }
    }

    public static class ForwardStarted
    extends SimulationEvent {
        public ForwardStarted(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FORWARD_STARTED;
        }

        public String toString() {
            return super.toString();
        }
    }
}

